/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.proxy.Proxy;
import fuzs.spikyspikes.mixin.accessor.LivingEntityAccessor;
import fuzs.spikyspikes.world.damagesource.SpikePlayerDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import fuzs.spikyspikes.world.phys.shapes.VoxelUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpikeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DecimalFormat TOOLTIP_DAMAGE_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("0.0"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), SpikeBlock::makeVisualShape));
    private static final Map<Direction, VoxelShape> COLLISION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, false)));
    private static final Map<Direction, VoxelShape> INTERACTION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, true)));
    public final SpikeMaterial spikeMaterial;

    public SpikeBlock(SpikeMaterial spikeMaterial, BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.spikeMaterial = spikeMaterial;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    private static VoxelShape makeVisualShape(Direction direction) {
        VoxelShape shape = SpikeBlock.makeStaircasePyramid(direction, 8, 2.0);
        Vec3[] outlineVectors = VoxelUtils.makePyramidEdges(VoxelUtils.makeVectors(0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 16.0, 0.0, 16.0, 0.0, 0.0, 16.0, 8.0, 16.0, 8.0));
        return new CustomOutlineShape(shape, VoxelUtils.scale(VoxelUtils.rotate(direction, outlineVectors)));
    }

    private static VoxelShape makeStaircasePyramid(Direction direction, int layers, double layerHeight) {
        Vec3[] vectors = new Vec3[layers * 2];
        int i = 0;
        int j = layers;
        while (i < layers) {
            vectors[2 * i] = new Vec3(8.0 - (double)j, (double)i * layerHeight, 8.0 - (double)j);
            vectors[2 * i + 1] = new Vec3(8.0 + (double)j, (double)(i + 1) * layerHeight, 8.0 + (double)j);
            ++i;
            --j;
        }
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    private static VoxelShape makeCollisionShape(Direction direction, boolean fullHeight) {
        Vec3[] vectors = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, fullHeight ? 16.0 : 11.0, 15.0);
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE_BY_DIRECTION.get(p_60555_.m_61143_((Property)FACING));
    }

    public VoxelShape m_5939_(BlockState p_52357_, BlockGetter p_52358_, BlockPos p_52359_, CollisionContext p_52360_) {
        return COLLISION_SHAPE_BY_DIRECTION.get(p_52357_.m_61143_((Property)FACING));
    }

    public VoxelShape m_5909_(BlockState p_60479_, BlockGetter p_60480_, BlockPos p_60481_, CollisionContext p_60482_) {
        return this.m_5940_(p_60479_, p_60480_, p_60481_, p_60482_);
    }

    public VoxelShape m_6079_(BlockState p_60547_, BlockGetter p_60548_, BlockPos p_60549_) {
        return INTERACTION_SHAPE_BY_DIRECTION.get(p_60547_.m_61143_((Property)FACING));
    }

    public VoxelShape m_7947_(BlockState p_60581_, BlockGetter p_60582_, BlockPos p_60583_) {
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos otherPos = pos.m_121945_(direction.m_122424_());
        if (direction == Direction.UP) {
            return SpikeBlock.m_49936_((BlockGetter)level, (BlockPos)otherPos);
        }
        return level.m_8055_(otherPos).m_60783_((BlockGetter)level, otherPos, direction);
    }

    public BlockState m_7417_(BlockState p_152036_, Direction p_152037_, BlockState p_152038_, LevelAccessor p_152039_, BlockPos p_152040_, BlockPos p_152041_) {
        if (((Boolean)p_152036_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_152039_.m_186469_(p_152040_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_152039_));
        }
        return p_152037_ == ((Direction)p_152036_.m_61143_((Property)FACING)).m_122424_() && !p_152036_.m_60710_((LevelReader)p_152039_, p_152040_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_152036_, p_152037_, p_152038_, p_152039_, p_152040_, p_152041_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        for (Direction direction : context.m_6232_()) {
            Direction opposite = direction.m_122424_();
            if (!(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)opposite)).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    public BlockState m_6843_(BlockState p_152033_, Rotation p_152034_) {
        return (BlockState)p_152033_.m_61124_((Property)FACING, (Comparable)p_152034_.m_55954_((Direction)p_152033_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_152030_, Mirror p_152031_) {
        return p_152030_.m_60717_(p_152031_.m_54846_((Direction)p_152030_.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_152043_) {
        p_152043_.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    public PushReaction m_5537_(BlockState p_152047_) {
        return PushReaction.DESTROY;
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity p_51151_) {
        block10: {
            SpikeMaterial material;
            LivingEntity entity;
            block11: {
                if (level.f_46443_ || !(p_51151_ instanceof LivingEntity) || !(entity = (LivingEntity)p_51151_).m_6084_()) break block10;
                if (!(entity instanceof Player)) break block11;
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_ || player.m_150110_().f_35934_) break block10;
            }
            if (((material = this.spikeMaterial).dealsFinalBlow() || entity.m_21223_() > material.damageAmount()) && (material.hurtsPlayers() || !(entity instanceof Player))) {
                if (material.dropsPlayerLoot()) {
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (blockEntity instanceof SpikeBlockEntity) {
                        SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
                        SpikeBlockEntity.attackPlayerLike(level, pos, level.m_8055_(pos), blockEntity2, entity, material.damageAmount());
                    }
                } else {
                    boolean doMobLoot = level.m_46469_().m_46207_(GameRules.f_46135_);
                    if (!material.dropsLoot()) {
                        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46135_)).m_46246_(false, level.m_7654_());
                    }
                    entity.m_6469_(SpikePlayerDamageSource.SPIKE_DAMAGE_SOURCE, material.damageAmount());
                    if (!material.dropsLoot()) {
                        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46135_)).m_46246_(doMobLoot, level.m_7654_());
                    }
                    if (!entity.m_6084_() && material.dropsJustExperience()) {
                        entity.m_6598_(null);
                        ((LivingEntityAccessor)entity).spikyspikes$dropExperience();
                    }
                }
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpikeBlockEntity(pos, state);
    }

    public void m_6402_(Level p_55179_, BlockPos p_55180_, BlockState p_55181_, @javax.annotation.Nullable LivingEntity p_55182_, ItemStack stack) {
        super.m_6402_(p_55179_, p_55180_, p_55181_, p_55182_, stack);
        BlockEntity blockEntity = p_55179_.m_7702_(p_55180_);
        if (blockEntity instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
            Map enchantments = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
            blockEntity2.setEnchantmentData(enchantments, stack.m_41610_());
        }
    }

    public void m_5871_(ItemStack p_56193_, @Nullable BlockGetter p_56194_, List<Component> tooltip, TooltipFlag p_56196_) {
        super.m_5871_(p_56193_, p_56194_, tooltip, p_56196_);
        if (p_56194_ == null) {
            return;
        }
        if (!Proxy.INSTANCE.hasShiftDown()) {
            tooltip.add((Component)Component.m_237110_((String)"item.spikyspikes.spike.tooltip.more", (Object[])new Object[]{Component.m_237115_((String)"item.spikyspikes.spike.tooltip.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)(this.m_7705_() + ".description")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"item.spikyspikes.spike.tooltip.damage", (Object[])new Object[]{Component.m_237110_((String)"item.spikyspikes.spike.tooltip.hearts", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(TOOLTIP_DAMAGE_FORMAT.format(this.spikeMaterial.damageAmount() / 2.0f)))}).m_130940_(this.spikeMaterial.tooltipStyle())}).m_130940_(ChatFormatting.GOLD));
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState p_49825_) {
        BlockEntity blockEntity;
        ItemStack stack = super.m_7397_(level, pos, p_49825_);
        if (this.spikeMaterial.acceptsEnchantments() && (blockEntity = level.m_7702_(pos)) instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
            stack.m_41751_(blockEntity2.m_187482_());
        }
        return stack;
    }
}

